using UnityEngine;
using System.Collections;

public class s_Key : MonoBehaviour
{
	bool mUsed = false;
	public Vector3 mOffset;
	
	void OnTriggerEnter(Collider other)
	{
		if (mUsed)
			return;
		
		if (transform.parent == null && other.gameObject.tag == "Player")
		{	
			//Scale it to the player
			if (other.transform.localScale.x > 0 && transform.localScale.x > 0
				|| other.transform.localScale.x < 0 && transform.localScale.x < 0)
				transform.localScale = new Vector3(transform.localScale.x * -1, transform.localScale.y, transform.localScale.z);
			
			Physics.IgnoreCollision(collider, other.gameObject.collider);
			collider.isTrigger = false;
			rigidbody.isKinematic = true;
			transform.parent = other.transform;
			transform.localPosition = mOffset;
		}
		else if (other.gameObject.tag == "Chest")
		{
			s_AudioManager.Get.PlayNonRewindSound(s_AudioManager.Get.mChestOpen);
			
			other.gameObject.GetComponent<s_OneShotAnimation>().enabled = true;
			transform.parent = null;
			other.collider.enabled = false;
			rigidbody.isKinematic = false;
			rigidbody.useGravity = true;
			mUsed = true;
		}
	}
	
}
